dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 4, 230, 220, "assets/images/table/castle", "assets/images/food/item_mark1", "B" );
LManager:AddNewTable( 2, 2, 200, 350, "assets/images/table/castle_2", "assets/images/food/item_mark2", "B" );
LManager:AddNewTable( 3, 3, 340, 350, "assets/images/table/castle", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 4, 3, 260, 485, "assets/images/table/castle", "assets/images/food/item_mark4", "R" );

useFloAsServer = 0;

useWineTable = 1;

numMoodBoosts = 2;
maxCoupleHappiness = 500;

--Level 5.1

--Group 1
guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = female04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 4, 1000);

--Group 2
guest = LManager.GenGuest(female02);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.percentRequestTissue = 40;
guest.likes={female01};
guest.matchType = table2;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(5, 6, 22000);


--Group 3
guest = LManager.GenGuest(female01);
guest.matchType = female03;
guest.percentRequestDrink = 70;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = female04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(7, 10, 35000);


--Group 4
guest = LManager.GenGuest(male02);
guest.likes={female04};
guest.matchType = female01;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(11, 12, 50000);


--Group 5
guest = LManager.GenGuest(male03);
guest.likes={female01};
guest.matchType = female01;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = male04;
guest.percentRequestCoffee = 40;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.likes={female01};
guest.matchType = table3;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = NOT_GUEST + male02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(13, 17, 90000);


--Group 6
guest = LManager.GenGuest(uncle);
guest.matchType = male03;
guest.percentRequestCoffee = 20;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = male03;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);
LManager:SetSeatingGroup(18, 19, 130000);

--Group 7
guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = male01;
guest.percentRequestCoffee = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + male03;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(20, 22, 150000);

LManager:AdjustGuestTolerance(140);

LManager:AddReseatingRequestForGuest(55000, aunt);
LManager:AddReseatingRequestForGuest(80000, male02);
LManager:AddReseatingRequestForGuest(140000, male03);

LManager:SetLevelSetting ("cakeTipDelay", 40000);
LManager:SetLevelSetting ("cakeTipChance", 100);

LManager:SetLevelSetting ("bridesmaidsDelay", 100000);
LManager:SetLevelSetting ("bridesmaidsChance", 100);

LManager:SetLevelSetting ("speakerDelay", 140000);
LManager:SetLevelSetting ("speakerChance", 40);


-- Set up the Level Settings
LManager:SetLevelNumber(5,1);
LManager:SetLevelScores(8800, 12000);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/new_dance_1.ogg","assets/audio/music/Dance Dance 1.ogg");
LManager:SetBackgroundImage("assets/images/bg_castle");
LManager:SetChairImage("assets/images/table/chair05");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );